//
//  Creating_Dependency_Between_OperationsAppDelegate.m
//  Creating Dependency Between Operations
//
//  Created by Vandad Nahavandipoor on 14/07/2011.
//  Copyright 2011 Pixolity Ltd. All rights reserved.
//

#import "Creating_Dependency_Between_OperationsAppDelegate.h"

@implementation Creating_Dependency_Between_OperationsAppDelegate

@synthesize window = _window;
@synthesize firstOperation;
@synthesize secondOperation;
@synthesize operationQueue;

- (void) firstOperationEntry:(id)paramObject{
  
  NSLog(@"Pierwsza operacja - obiekt parametru = %@", 
        paramObject);
  
  NSLog(@"Pierwsza operacja - wątek główny = %@", 
        [NSThread mainThread]);
  
  NSLog(@"Pierwsza operacja - wątek bieżący = %@", 
        [NSThread currentThread]);
  
}

- (void) secondOperationEntry:(id)paramObject{
  
  NSLog(@"Druga operacja - obiekt parametru = %@",
        paramObject);
  
  NSLog(@"Druga operacja - wątek główny = %@", 
        [NSThread mainThread]);
  
  NSLog(@"Druga operacja - wątek bieżący = %@", 
        [NSThread currentThread]);
  
}

- (BOOL)            application:(UIApplication *)application 
  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
  
  NSNumber *firstNumber = [NSNumber numberWithInteger:111];
  NSNumber *secondNumber = [NSNumber numberWithInteger:222];
  
  self.firstOperation = [[NSInvocationOperation alloc]
                         initWithTarget:self
                         selector:@selector(firstOperationEntry:)
                         object:firstNumber];
  
  self.secondOperation = [[NSInvocationOperation alloc]
                          initWithTarget:self
                          selector:@selector(secondOperationEntry:)
                          object:secondNumber];
  
  [self.firstOperation addDependency:self.secondOperation];
  
  self.operationQueue = [[NSOperationQueue alloc] init];
  
  /* Dodanie operacji do kolejki. */
  [self.operationQueue addOperation:self.firstOperation];
  [self.operationQueue addOperation:self.secondOperation];
  
  NSLog(@"To jest wątek główny.");
  
  self.window = [[UIWindow alloc] initWithFrame:
                 [[UIScreen mainScreen] bounds]];
  self.window.backgroundColor = [UIColor whiteColor];
  [self.window makeKeyAndVisible];
  return YES;
}

//- (BOOL)            application:(UIApplication *)application 
//  didFinishLaunchingWithOptions:(NSDictionary *)launchOptions{
//  
//    self.window = [[UIWindow alloc] initWithFrame:
//                   [[UIScreen mainScreen] bounds]];
//    self.window.backgroundColor = [UIColor whiteColor];
//    [self.window makeKeyAndVisible];
//    return YES;
//}

- (void)applicationWillResignActive:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy aplikacja przechodzi ze stanu aktywnego do nieaktywnego. Może być wywołana w określonych sytuacjach (na przykład w chwili odbywania rozmowy telefonicznej lub po otrzymaniu wiadomości SMS) bądź kiedy użytkownik kończy działanie aplikacji. Metoda rozpoczyna proces przejścia do stanu pozostania w tle. Tę metodę można wykorzystać do wstrzymania wykonywania bieżących zadań, wyłączenia liczników czasu, zmniejszenia liczby klatek generowanych przez OpenGL ES. W grach ta metoda powinna być użyta do wstrzymania gry (pauza).
   */
}

- (void)applicationDidEnterBackground:(UIApplication *)application
{
  /*
   Tę metodę należy wykorzystać do zwolnienia zasobów współdzielonych, zapisania danych użytkownika, wyzerowania liczników czasu oraz do przechowania takiej ilości informacji o stanie, która pozwoli na przywrócenie aplikacji do stanu bieżącego. Jeżeli aplikacja obsługuje działanie w tle, w chwili kończenia działania należy wywołać tę metodę zamiast applicationWillTerminate:.
   */
}

- (void)applicationWillEnterForeground:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana podczas przechodzenia aplikacji ze stanu aktywnego do działania w tle. Można więc tutaj wycofać wiele zmian wprowadzonych w chwili przechodzenia do stanu działania w tle.
   */
}

- (void)applicationDidBecomeActive:(UIApplication *)application
{
  /*
   W tej metodzie można wznowić działanie zadań zatrzymanych (lub nieuruchomionych), gdy aplikacja była nieaktywna. Jeżeli aplikacja znajdowała się w trybie działania w tle, w metodzie można przeprowadzić odświeżenie interfejsu użytkownika.
   */
}

- (void)applicationWillTerminate:(UIApplication *)application
{
  /*
   Ta metoda jest wywoływana, gdy działanie aplikacji ma zostać zakończone. Zapoznaj się z opisem metody applicationDidEnterBackground:.
   */
}

@end
